# Safetycar V1.01 - 12-02-12 - Added option for lapped cars to overtake		#
# Safetycar V1.02 - 12-04-13 - Send messages about SC as soon as it happens	#
#################################################################################

CatchEvent OnMSO( $userName, $text ) # Player event

	$idxOfFirtsSpace = indexOf( $text, " ");
	IF( $idxOfFirtsSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirtsSpace );
	  $argv = trim( subStr( $text,$idxOfFirtsSpace ) );
	ENDIF

	SWITCH( $command )

		CASE "!sc":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
				Safetycar_gui( $KeyFlags );
			ELSE
				privMsg(langEngine( "%{main_notadmin}%" ));
			ENDIF
			BREAK;
	ENDSWITCH
EndCatchEvent

Sub Safetycar_gui( $KeyFlags )
	IF ($safetycar_status == "out")
	THEN
	  openPrivButton( "sc_out",75,11,10,5,5,-1,16,"^2SC OUT",SC_OUT);
	ELSE
	  openPrivButton( "sc_out",75,11,10,5,5,-1,16,"^3SC OUT",SC_OUT);
	ENDIF

	IF ($safetycar_status == "lapped")
	THEN
	  openPrivButton( "sc_lapped",85,11,10,5,5,-1,16,"^2SC LAP",SC_LAP);
	ELSE
	  openPrivButton( "sc_lapped",85,11,10,5,5,-1,16,"^3SC LAP",SC_LAP);
	ENDIF

	IF ($safetycar_status == "in")
	THEN
	  openPrivButton( "sc_in",95,11,10,5,5,-1,16,"^2SC IN",SC_IN);
	ELSE
	  openPrivButton( "sc_in",95,11,10,5,5,-1,16,"^3SC IN",SC_IN);
	ENDIF

	IF ($safetycar_status == "off")
	THEN
	  openPrivButton( "sc_off",105,11,10,5,5,-1,16,"^2SC OFF",SC_OFF);
	ELSE
	  openPrivButton( "sc_off",105,11,10,5,5,-1,16,"^3SC OFF",SC_OFF);
	ENDIF

	openPrivButton( "close_sc",115,11,10,5,5,-1,16,"^7Close",Close_SC);
EndSub

Sub SC_OUT( $KeyFlags,$id )
	$safetycar_status="out";
	$safetycar_message_1="^1!^3 SAFETYCAR DEPLOYED ^1!^8";
	$safetycar_message_2="^3do ^1not^3 overtake anyone^8";
	$safetycar_message_3="^3except people in crash or pits^8";
	cmdLFS ("/rcm ^1!^3 Safety car deployed, ^1NO^3 overtaking ^1!^8");
	cmdLFS ("/rcm_all");

	$mList = GetListOfPlayers("N");
	$mCount = arrayCount( $mList );
	$plyNum=0;

	WHILE ($plyNum < $mCount)
		$uName = $mList[$plyNum];

		IF ( GetPlayerVar( $uName,"config_pb_display_mode_graphical") == "on" )
		THEN
		  closeButton( $uName,"pitboard_current_sector_1_txt&pitboard_last_sector_1_txt&pitboard_best_sector_1_txt");
		  closeButton( $uName,"pitboard_current_sector_1&pitboard_last_sector_1&pitboard_best_sector_1" );
		  closeButton( $uName,"pitboard_before_sector_1&pitboard_behind_sector_1" );
		  closeButton( $uName,"pitboard_current_sector_2_txt&pitboard_last_sector_2_txt&pitboard_best_sector_2_txt");
		  closeButton( $uName,"pitboard_current_sector_2&pitboard_last_sector_2&pitboard_best_sector_2" );
		  closeButton( $uName,"pitboard_before_sector_2&pitboard_behind_sector_2");
		  closeButton( $uName,"pitboard_current_sector_3_txt&pitboard_last_sector_3_txt&pitboard_best_sector_3_txt");
		  closeButton( $uName,"pitboard_current_sector_3&pitboard_last_sector_3&pitboard_best_sector_3" );
		  closeButton( $uName,"pitboard_before_sector_3&pitboard_behind_sector_3");
		  closeButton( $uName,"pitboard_current_sector_last_txt&pitboard_last_sector_last_txt&pitboard_best_sector_last_txt");
		  closeButton( $uName,"pitboard_current_sector_last&pitboard_last_sector_last&pitboard_best_sector_last" );
		  closeButton( $uName,"pitboard_before_sector_last&pitboard_behind_sector_last" );
		  closeButton( $uName,"pitboard_information&pitboard_information_2" );
		  closeButton( $uName,"pitboard_safetycar_message_1&pitboard_safetycar_message_2&pitboard_safetycar_message_3" );

		  openButton( $uName,"pitboard_safetycar_bg",GetPlayerVar ( $uName,"left_right_coordinate")+1,GetPlayerVar ( $uName,"top_bottom_coordinate")+13,30,28,4,-1,16,"" );
		  openButton( $uName,"pitboard_safetycar_message_1",GetPlayerVar ( $uName,"left_right_coordinate")+1,GetPlayerVar ( $uName,"top_bottom_coordinate")+13,30,14,4,-1,0, $safetycar_message_1 );
		  openButton( $uName,"pitboard_safetycar_message_2",GetPlayerVar ( $uName,"left_right_coordinate")+1,GetPlayerVar ( $uName,"top_bottom_coordinate")+27,30,7,4,-1,0, $safetycar_message_2 );
		  openButton( $uName,"pitboard_safetycar_message_3",GetPlayerVar ( $uName,"left_right_coordinate")+1,GetPlayerVar ( $uName,"top_bottom_coordinate")+34,30,7,4,-1,0, $safetycar_message_3 );
		ENDIF

		IF ( GetPlayerVar(  $uName,"config_pb_display_mode_text" ) == "on" )
		THEN
		  PrivMsg ( $uName,"^7INF: " . $safetycar_message_1 );
		  PrivMsg ( $uName,"^7INF: " . $safetycar_message_2 );
		  PrivMsg ( $uName,"^7INF: " . $safetycar_message_3 );
		ENDIF

		openButton( $uName,"safetycar_statusbar_bg",50,0,100,10,4,-1,16,"" );
		openButton( $uName,"safetycar_light_1",51,1,10,8,4,-1,0 | ISB_BLINK,"^1! ^3! ^1!" );
		openButton( $uName,"safetycar_statusbar_text",61,1,78,8,4,-1,0,"^3Safetycar deployed, ^1NO^3 overtaking" );
		openButton( $uName,"safetycar_light_2",139,1,10,8,4,-1,0 | ISB_BLINK,"^1! ^3! ^1!" );

		$plyNum=$plyNum+1;
	ENDWHILE

	Safetycar_gui( $KeyFlags );
EndSub

Sub SC_LAP( $KeyFlags,$id )
	$safetycar_status="lapped";
	$safetycar_message_1="^2!^3 SAFETYCAR ^2IN^3 SOON ^2!^8";
	$safetycar_message_2="^3Lapped cars may now overtake^8";
	$safetycar_message_3="^3take position at end of field^8";
	cmdLFS ("/rcm ^3 Lapped cars may now overtake^8");
	cmdLFS ("/rcm_all");

	TextPrivButton( "pitboard_safetycar_message_1", $safetycar_message_1);
	TextPrivButton( "pitboard_safetycar_message_2", $safetycar_message_2);
	TextPrivButton( "pitboard_safetycar_message_3", $safetycar_message_3);

	$mList = GetListOfPlayers("N");
	$mCount = arrayCount( $mList );
	$plyNum=0;

	WHILE ($plyNum < $mCount)
		$uName = $mList[$plyNum];

		IF ( GetPlayerVar(  $uName,"config_pb_display_mode_text" ) == "on" )
		THEN
		  PrivMsg ( $uName,"^7INF: " . $safetycar_message_1 );
		  PrivMsg ( $uName,"^7INF: " . $safetycar_message_2 );
		  PrivMsg ( $uName,"^7INF: " . $safetycar_message_3 );
		ENDIF

		$plyNum=$plyNum+1;
	ENDWHILE

	TextPrivButton( "safetycar_light_1", "^3! ^1! ^3!");
	TextPrivButton( "safetycar_statusbar_text", "^3Lapped cars may now overtake. Take position at end of field");
	TextPrivButton( "safetycar_light_2", "^3! ^1! ^3!");

	Safetycar_gui( $KeyFlags );
EndSub

Sub SC_IN( $KeyFlags,$id )
	$safetycar_status="in";
	$safetycar_message_1="^2!^3 SAFETYCAR ^2IN^3 THIS LAP ^2!^8";
	$safetycar_message_2="^3do ^1not^3 overtake anyone^8";
	$safetycar_message_3="^3before start-/finishline^8";
	cmdLFS ("/rcm ^3Safety car ^2in^3 this lap");
	cmdLFS ("/rcm_all");

	TextPrivButton( "pitboard_safetycar_message_1", $safetycar_message_1);
	TextPrivButton( "pitboard_safetycar_message_2", $safetycar_message_2);
	TextPrivButton( "pitboard_safetycar_message_3", $safetycar_message_3);

	$mList = GetListOfPlayers("N");
	$mCount = arrayCount( $mList );
	$plyNum=0;

	WHILE ($plyNum < $mCount)
		$uName = $mList[$plyNum];

		IF ( GetPlayerVar(  $uName,"config_pb_display_mode_text" ) == "on" )
		THEN
		  PrivMsg ( $uName,"^7INF: " . $safetycar_message_1 );
		  PrivMsg ( $uName,"^7INF: " . $safetycar_message_2 );
		  PrivMsg ( $uName,"^7INF: " . $safetycar_message_3 );
		ENDIF

		$plyNum=$plyNum+1;
	ENDWHILE

	TextPrivButton( "safetycar_light_1", "^3! ^2! ^3!");
	TextPrivButton( "safetycar_statusbar_text", "^3 SAFETYCAR ^2IN^3 THIS LAP");
	TextPrivButton( "safetycar_light_2", "^3! ^2! ^3!");

	Safetycar_gui( $KeyFlags );
EndSub

Sub SC_OFF( $KeyFlags,$id )
	$safetycar_status="off";

	$mList = GetListOfPlayers("N");
	$mCount = arrayCount( $mList );
	$plyNum=0;

	WHILE ($plyNum < $mCount)
		$uName = $mList[$plyNum];

		closeButton( $uName,"safetycar_statusbar_bg" );
		closeButton( $uName,"safetycar_light_1" );
		closeButton( $uName,"safetycar_statusbar_text" );
		closeButton( $uName,"safetycar_light_2" );

		$plyNum=$plyNum+1;
	ENDWHILE

	Safetycar_gui( $KeyFlags );
EndSub

Sub Close_SC( $KeyFlags,$id )
	closePrivButton( "sc_bg&sc_out&sc_lapped&sc_in&sc_off&close_sc");
EndSub